<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>IBSheet7-Product</title>

		<link rel="stylesheet" type="text/css" href="../Sheet/js/css/default/main.css"/>
        <script type="text/javascript" src="../js/common.js"></script>
        <script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
        <script type="text/javascript" src="../Chart/ibchart.js"></script>
        <script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
        <script type="text/javascript" src="../Sheet/js/ibsheet.js"></script>
        <script type="text/javascript" src="../Sheet/js/locale/ko.js"></script>
        <script type="text/javascript">
        	var pageheightoffset = 310;
			function getSeriesType() {
				switch ($('#chartType').val()) {
					case "LINE":
						return "line";
					case "SPLINE":
						return "spline";
					case "SCATTER":
						return "scatter";
					case "BAR":
						return "bar";
					case "COLUMN":
						return "column";
					case "AREA":
						return "area";
					case "AREASPLINE":
						return "areaspline";
					/*case "PIE":
						return IBChartType.PIE;*/
				}
			}

            function PageLoad() {
            	init_sheet();

            	createIBChart("myChart", "myChart", {
            		width: "100%",
            		height: "100%"
            	});

                initChart(myChart, "IBSheet와 연동");
            }
            function init_sheet() {
				var initSheet = {};
                initSheet.Cfg = {PrevColumnMerge:1,DataMerge:1};
                
                initSheet.Cols = [
                    {Header:"통신사",Type:"Text",RelWidth:1,Width:130,Name:"A",Align:"Center"},
                    {Header:"요금제",Type:"Text",RelWidth:1,Width:100,Name:"B"},
                    {Header:"요금할인",Type:"Int",RelWidth:1,Width:80,Name:"C", Align:"Right"},
                    {Header:"기본료",Type:"Int",RelWidth:1,Width:85,Name:"D", Align:"Right"},
                    {Header:"청구요금",Type:"Int",RelWidth:1,Width:85,Name:"E", Align:"Right"},
                    {Header:"할인총액",Type:"Int",RelWidth:1,Width:85,Name:"F",Align:"Right"},
                    {Header:"최종할인",Type:"Int",RelWidth:1,Width:85,Name:"G", Align:"Right"},

				];
				
				initSheet.Events = {
                    onRenderFirstFinish:function(evtParam){
                        evtParam.sheet.doSearch("sheetData3.jsp");
                    }
                };
                IBSheet.create({
                    id:"mySheet",
                    el:"sheetDiv",
                    options:initSheet
                });




                
            }
            function getTitle(s,r,c) {
                var rows = r.split("|");
                var rtnTitle = "";
                for(var i=0;i<rows.length;i++) {
                    rtnTitle += s.GetCellText(rows[i],c)+"|";
                }
                return rtnTitle.substring(0,rtnTitle.length-1);
            }
            function chartDraw() {
				var selArea = mySheet.getSelectedRanges (0,0),
					//여러개 선택해도 첫번째 선택한 것을 기준으로 차트를 그리자.
					rowsArr = [] ,
					colsArr = [],
					seriestypeArr = [],
					legendseriesnameArr = [],
					i = 0,
					max = 0,
					seriestypeStr = getSeriesType();

				if(selArea.length == 0) {
					alert("셀을 선택해 주세요.");
					return;
				}
				rowsArr = mySheet.getDataRows().splice(selArea[0][4]-1,selArea[0][6]-1);
				colsArr = mySheet.getCols().splice(selArea[0][5],selArea[0][7]);
				

				for(i=0, max=colsArr.length; i<max; i++) {
					seriestypeArr.push( seriestypeStr );
					legendseriesnameArr.push(mySheet.getValue(mySheet.Header, colsArr[i]));
				}

				//alert('seriestypeStr :' + seriestypeStr + '\tcols :' + 'rows :' + selRows + '\tcols :' + selCols + ' legendseriesnameArr:' + JSON.stringify(legendseriesnameArr) + ' seriestypeArr:' + JSON.stringify(seriestypeArr) + ' rowsArr:' + JSON.stringify(rowsArr) );

                initChart(myChart, "IBSheet와 선택 연동");
                try {
                    var pparam = {
                        datadirection:"vertical"
                        ,datarowcol:colsArr
                        ,legendseriesname:legendseriesnameArr
                        ,legendtitle:"시트와 차트"
                        ,startdatarowcol:rowsArr[0]
                        ,enddatarowcol:rowsArr[rowsArr.length-1]
                        ,labelrowcol:"B"
                        ,startlabelrowcol:rowsArr[0]
                        ,endlabelrowcol:rowsArr[rowsArr.length-1]
                        ,labeldirection:"vertical"
                        ,seriestype:seriestypeArr
                    };



                    sheet2chart(mySheet,myChart,pparam);
                } catch(e) {
//                    alert(e.message);
                }
            }
            function initChart(cObj, tTxt) {
				cObj.setOptions({
					chart:{
						type:"column",
						plotBackgroundColor : "#F7FAFB",
						plotBorderColor:"#A9AEB1",
						plotBorderWidth:0.5
					},
					title:{
						text:tTxt,
						style:{
							color:"#15498B",
							fontFamily:"Dotum",
							fontWeight:"bold"
						}
					},
					yAxis:{
						title:{
							text:""
						}
					}
				});
            }


            function mySheet_OnMouseDown(Button, Shift, X, Y){

            	var r = mySheet.MouseRow();
            	var c = mySheet.MouseCol();
            	try{
            	mySheet.SelectCell(r,c);
            }catch(e){
            	alert(e.message);
            	}


            }
        </script>
    </head>
    <body onload="PageLoad()">
        <div class="page_title">
            <span><a class="closeDepth" href="#">closeDepth</a></span>
            <span class="title color_sheet">시트와 연동  > <b>선택 영역 데이터 읽기</b></span>
        </div>
        <div class="main_content">
            <div class="exp_product" style="height:15px;padding:2px">
				IB Sheet와 연동기능을 확인합니다.<br>
				시트에서 특정 영역을 드레그 하여 선택하신 후,차트 생성 버튼을 클릭해 주세요.
            </div>
            <p class="subtit_chart">기능 버튼</p>
            <div class="ib_function2 border_chart"  style="height:30px;padding:5px">
            	<table class="ib_column2">
					<tr>
						<th class="tit">차트표현</th>
						<td>
							<select class="input_all" id="chartType" title="막대 선택">
							<option value="BAR" >바</option>
							<option value="COLUMN" selected>막대</option>
							<option value="AREA" >영역</option>
							<option value="AREASPLINE" >부드러운 영역</option>
							<option value="LINE" selected >꺽은선</option>
							<option value="SPLINE" >부드러운선</option>
							<option value="SCATTER" >산점</option>
							</select>
						</td>
						<td class="r20">
							<a class="f2_btn_white btn_chart" onclick="chartDraw()">차트생성</a>
						</td>
					</tr>
				</table>
			</div>
			<div class="ib_product" style="width:100%;">
				<div style="width:48%;height:100%;float:left">
					<p class="subtit_chart">IB Sheet</p>
	                <div id="sheetDiv" style="width:100%;height:100%"></div>
				</div>
				<div style="width:2%;float:left">&nbsp;</div>
				<div  style="width:50%;height:100%;float:left">
					<p class="subtit_chart">IB Chart</p>

					<div id="myChart"></div>
				</div>
            </div>
        </div>
    </body>
</html>